/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.soundscool.network.packet.server;

import com.dynious.soundscool.handler.SoundHandler;
import com.dynious.soundscool.network.packet.IPacket;
import io.netty.buffer.ByteBuf;

public class ServerPlaySoundPacket
implements IPacket {
    String soundName;
    String identifier;
    int x;
    int y;
    int z;

    public ServerPlaySoundPacket() {
    }

    public ServerPlaySoundPacket(String soundName, String identifier, int x, int y, int z) {
        this.soundName = soundName;
        this.identifier = identifier;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Override
    public void readBytes(ByteBuf bytes) {
        int soundLength = bytes.readInt();
        char[] fileCars = new char[soundLength];
        for (int i = 0; i < soundLength; ++i) {
            fileCars[i] = bytes.readChar();
        }
        this.soundName = String.valueOf(fileCars);
        int identLength = bytes.readInt();
        char[] identCars = new char[identLength];
        for (int i = 0; i < identLength; ++i) {
            identCars[i] = bytes.readChar();
        }
        this.identifier = String.valueOf(identCars);
        this.x = bytes.readInt();
        this.y = bytes.readInt();
        this.z = bytes.readInt();
        SoundHandler.playSound(this.soundName, this.identifier, this.x, this.y, this.z);
    }

    @Override
    public void writeBytes(ByteBuf bytes) {
        bytes.writeInt(this.soundName.length());
        for (char c : this.soundName.toCharArray()) {
            bytes.writeChar((int)c);
        }
        bytes.writeInt(this.identifier.length());
        for (char c : this.identifier.toCharArray()) {
            bytes.writeChar((int)c);
        }
        bytes.writeInt(this.x);
        bytes.writeInt(this.y);
        bytes.writeInt(this.z);
    }
}

